package gov.va.med.mhv.usermgmt.util;

public class NumberToWordUtil {

	private static final String[] tensNames = { "", "TEN", "TWENTY", "THIRTY", "FORTY", "FIFTY", "SIXTY", "SEVENTY",
			"EIGHTY", "NINETY" };

	private static final String[] numNames = { "", "ONE", "TWO", "THREE", "FOUR", "FIVE", "SIX", "SEVEN", "EIGHT",
			"NINE", "TEN", "ELEVEN", "TWELVE", "THIRTY", "FOURTEEN", "FIFTEEN", "SIXTEEN", "SEVENTEEN", "EIGHTEEN",
			"NINETEEN" };

	/**
	 * this converts a number to it's word equilavent
	 * 1 = ONE, 2 = TWO, ...
	 * note: it only handles less than 1000
	 * @param number
	 * @return
	 */
	public static String convert(int number) {
		String soFar;

		if (number % 100 < 20) {
			soFar = numNames[number % 100];
			number /= 100;
		} else {
			soFar = numNames[number % 10];
			number /= 10;

			soFar = tensNames[number % 10] + soFar;
			number /= 10;
		}
		
		if (number == 0) {
			return soFar;
		}
		
		return numNames[number] + "HUNDRED" + soFar;
	}
}
